
# Croatian translation notes

Notes about grammar, transliteration, orthography, consistent use of words, links, hints etc.</br>
This document provides short hints only for Croatian translation and is by no means a complete guide.

## Table of Contents

- [Croatian translation notes](#croatian-translation-notes)
  - [Table of Contents](#table-of-contents)
  - [Tricky English words and translation of words](#tricky-english-words-and-translation-of-words)
    - [Resolved Translation](#resolved-translation)
    - [Unresolved Translation](#unresolved-translation)
    - [Wording Consistency](#wording-consistency)
    - [Untranslated words](#untranslated-words)
  - [Grammar and translation consistency](#grammar-and-translation-consistency)
    - [Formal and informal forms](#formal-and-informal-forms)
    - [Grammatical gender](#grammatical-gender)
    - [Other grammar](#other-grammar)
  - [Placeholder genders](#placeholder-genders)
    - [Feminine](#feminine)
    - [Masculine](#masculine)
    - [Neuter](#neuter)
    - [Mixed gender](#mixed-gender)
    - [Guess gender](#guess-gender)
    - [Gender not applicable](#gender-not-applicable)
    - [Unresolved gender](#unresolved-gender)
  - [City names](#city-names)
    - [Cities written in English](#cities-written-in-english)
    - [Cities written in Latin letter](#cities-written-in-latin-letter)
    - [Cities written in Cyrillic letter](#cities-written-in-cyrillic-letter)
    - [Cities written in other letters](#cities-written-in-other-letters)
    - [Unknown letter](#unknown-letter)
  - [Resources](#resources)
    - [Hints](#hints)
    - [Links](#links)
  - [Gotcha's](#gotchas)

## Tricky English words and translation of words

Words in this section are difficult to translate properly or difficult for consistency reasons.

Choice of words for consistent translation in order of preference and depending on context.</br>
First highlighted word is used and additional highlighted words are only hints, and may be used
either depending on context or by replacing all matching alternative words as applicable.</br>
Words in parentheses are incorrect either because English translation has another word, or because
we already use them to translate some other English word in translation file.</br>
Words outside parentheses are hints as to when highlighted word should be used.

### Resolved Translation

- Trade `Trgovina`, (Razmjena)
- Capture `Zauzeti` stvar, `Zarobiti` živo biće
- We Love The King Day `Volimo Kralja`, `Dan Obožavanja Kralja`
- Policy `Politika`, (Polica)
- Pillage `Opljačkati`
- Default `Zadano`, `Uobičajeno`
- Exploring `Istraživati`, `Otkrivati`
- Move `Pokreni`, `Pomakni`, `Premjesti`
- Annex `Pripojiti`, `Aneksirati`
- Capital `Prijestolnica`
- Capital City `Glavni Grad`
- Turn `Potez`, `Krug`
- Declaration `Deklaracija`, (Izjava)
- Unique `Unikatni`, `Jedinstveni`
- Tutorial `Poduka`, `Vodič`
- Improvement, Improve `Unaprjeđenje`, `Unaprjediti`
- Enhance `Unaprjediti`, (Poboljšati)
- Camp, Encampment `Logor`, `tabor` barbarski kamp
- Camp `Kamp` unaprjeđenje
- Air Sweep `Čišćenje Zraka`
- Fog of War `Ratna Magla`
- Replay `Ponovno Reproduciraj`
- AutoPlay `Automatska Igra`, (Automatska Reprodukcija)
- Level(up) `Razina`, `Prijeći na novu razinu`
- Sprout `Klijanje`, `Klica`
- Spread `Širiti`, `Proširiti`, `Raširiti`
- Repository `Repozitorij`, `Spremište`
- About `O igri`, `O programu`
- Toggle `Uključi/isključi`, `Prekidač` (Uključivanje, Isključivanje)
- Boost `Poticaj`
- Luxury Resource `Luksuzni Resurs`
- Luxury `Luksuz`
- Sight `Vidokrug`
- Rough `Neravan`
- Spawn `Iznjedriti`, `Pojavljivanje`, `Nastanak`, `Izroditi`
- Embark `Ukrcaj na brod`
- World wrap `Okret oko svijeta`
- Nuke `Nuklearni udar`
- Human `Čovjek`, (Osoba)
- Rifleman `Pucač puškom`
- Amphibious `Amfibijski`
- Cycle `Kružiti`, `Ciklus`
- Deconversion `Dekonverzija`
- Music Player `Svirač Glazbe`
- Online `Internetski`, `Mrežni`, `Online`
- cutout `izrez`
- Fallout `Radioaktivno područje`
- Pangaea `Pangea`
- Dogfighting `Zračna borba`
- Floodfill `Prepravljeno popunjenje`
- Perlin `Perlinov Šum`
- Multiplayer `Igra više igrača`

TODO: Might need better translation!

- Raid `Izvršiti prepad`, `Upasti u/na` (Izvršiti raciju)
- Paradrop `Skok padobranom`
- Hotseat `Lokalna više-korisnička igra`, `Lokalna igra više igrača` (Više-korisnička igra, Igra više igrača)
- Stats `Statistike` (Prinosi)
- Tile Damage `Šteta od polja`, (Poljska šteta, Poljna šteta)
- Melee Water `Bliska Borba na Vodi`
- WaterMelee `BliskaBorbaNaVodi`

TODO: Possibly better translation depnding on context

- `... from ...` `od` instead of `iz` and vice versa
- `... per ...` `za` instead of `po` and vice versa

### Unresolved Translation

Not yet translated words, mostly because no sane translation exits to Croatian language.

- None

### Wording Consistency

- Show `Pokaži`
- Display `Prikaz`, `Prikaži`
- Reset `Resetiraj`, `Ponovo postavi`
- Population `Stanovnik`
- Citizen `Građanin`
- Promotion `Promaknuće`
- Coup `Puč`, `Državni udar`
- Invalid `Nevaljani`, `Nevažeći`
- Tile `Polje`
- Place `Postavi`
- Gift `Poklon`, `Dar`
- Supply `Opskrba`
- Consume(s)/Consuming `Konzumira/Konzumirati`, `Troši/Potrošnja`, `Iskoristiti`
- Spend(s) `Troši/Potrošnja`, `Provoditi`
- Move `Pokreni`, `Pomakni`, `Premjesti`
- Movement `Kretnja`, `Pokret`
- Chance `Šansa`, `Vjerojatnost`
- Probability, Likelihood `Vjerojatnost`
- Generating `Generiranje`, (Stvaranje, Rođenje)
- Fresh Water `Slatka voda` (Svježa voda)
- Menu `Izbornik`
- Spectate `Promatrati`
- Conduct `Sprovedi`
- BC `pr. Kr.`, (prije Krista)
- AD `po. Kr.`, (poslije Krista)
- Range(d) `Domet`, `Dalekometni`
- Screen `Zaslon`
- Specialist `Specialist`, (Stručnjak)
- Double-click `Dupli klik`
- Breakdown `Pregled`
- Cost `Cijena`, `Trošak`
- Costs `Cijene`, `Stoji`, `Košta`
- Span `Raspon`
- Range `Domet`
- Button `Gumb` (Dugme)
- Take `Primiti`,
- Suffer `Trpjeti`
- Create `Stvori`, `Kreiraj`
- Map `Karta`, `Mapa`
- Requires `Zahtjeva`, `Treba`
- Required `Potrebno`
- Demand(s) `Zahtjev(a)`
- Need(s) `Treba`, `Potreba`
- Needed `Potrebno`
- Request `Zamolba`, `Molba`, `Tražiti`
- Willing(ness) `Voljni`, `Voljnost`
- non-fresh water `morska voda`, `slana voda`
- Scout `Izviđač`
- Explorer `Istraživač`
- Cancel `Poništi`, `Otkaži` (Ukini)
- Choose `Odaberi`, `Izaberi`
- Select `Odaberi` (Izaberi)
- Discovering `Otkriće`, `Otkrivanje`
- Acquire `Stekni`, `Kupi`
- Gain `Dobij` `Stekni`
- Upon `Prilikom`, `Po`, `Nakon`, `Na`, `Nad` (Pri)

### Untranslated words

Where needed, deliberately not translated due to UI size limitations,
shorter synonymous word is used instead in these cases.

- AI `Robot`, `Umjetna inteligencija`

Deliberately not translated because translation is for informational purposes only,
in official Croatian language these are written in their original form but are pronounced differently.

- Angkor Wat (Gradski Hram)
- Chichen Itza (Na zdencu čarobnjaka vode)
- Machu Picchu (Stari vrhovi)
- Wat (Hram)
- Notre Dame (Naše Gospe)

Deliberately not translated because these names retain their writing even though pronounced
differently.

- Wu Zetian
- George Washington
- Gandhi
- Otto von Bismarck
- Hiawatha
- Pachacuti

Deliberately shorter name for convenience

- Las Palmas (Las Palmas de Gran Canaria)

Borrowed translation because no translation exists

- Hakkapeliitta
- Chu-Ko-Nu
- Hwacha
- Minuteman

[Table of Contents](#table-of-contents)

## Grammar and translation consistency

Section outlining what is to be continuously checked for consistency,
e.g. trough gameplay or by revisiting properties file.

### Formal and informal forms

Use of formal form:

- In Civilopedia
- When the game/gameplay asks/tells something from/to player
- Victory screen and victory conditions

Use of informal form:

- In diplomacy, both major and minor civs, and quests of city states
- Nation introduction during new game
- When the player gives orders to game
- Technology and great building proverbs
- New game screen lines
- Map editor lines
- Multiplayer screen lines
- World Screen UI lines
- City Screen lines
- Technology UI lines

Exceptions (use sparingly to retain consistency):

- Use formal form where appropriate to avoid grammatical gender
- Use formal form where appropriate to simplify grammar
- Switch between formal or informal (mixture) where appropriate to make it sound more natural or consistent, e.g. UI prompt

NOTE: Switching between formal and informal is used in diplomacy

Examples (formal vs informal, to check for correct usage e.g. in combination with placeholders):

- Vi vs Ti
- Vas vs Tebe, te
- Vama vs Tebi
- Vam vs Ti
- Vaš vs Tvoj
- Vaša vs Tvoja
- Vašeg vs Tvojeg
- Vašu vs Tvoju
- Vašom vs Tvojom
- Vašoj vs Tvojoj
- Vaši vs Tvoji
- Vaše vs Tvoje
- Ćete vs Ćeš

- `*ite`, `*jeli` vs - `*iš` (e.g Želite, Željeli etc.)
- `*ite` vs - `*di`, `*ži`, `*ri`, `*zi`, `*ni`, `*ti`, `*ji`, `*si` etc.
- `*ajte` vs `*aj`
- `*ete` vs `*eš`
- `*ijte` vs - `*iješ`, `*ij` (e.g Dobij etc.)
- `*ate` vs - `*aš` (e.g Trebate, Morate, Dobivate etc.)
- `*ili` vs - `*io`, `*la` (e.g Prekršili etc.)

Use regex for quick find, e.g. for `*iš`:

```regex
\w+iš
```

### Grammatical gender

Examples (to check for correct usage e.g. in combination with placeholders):

- Naš vs Naša
- Našim vs Našom
- Vaš vs Vaša
- Vašim vs Vašom
- Našeg vs Našu
- Vašeg vs Vašu
- Njihov vs Njihova
- Njihovim vs Njihovom
- Njihovog vs Njihove

Exceptions:

- Use neuter where appropriate to avoid grammatical gender

### Other grammar

Correct vs incorrect

- Trenutačno vs Trenutno (Are two different meanings)
- Molim vs Molimo
- Ne može vs Nemože
- Ne smije vs Nesmije
- s vs sa (Depends on orthography)
- s `[` vs sa `[`
- Unikat vs Unikatno/i (Depends on context)
- Osnivati (nesvršeni glagol) vs Osnovati (svršeni glagol)

TODO: `... se ...` can be placed before or after verb/noun/adjective etc.
TODO: Check for double spaces
TODO: Check casing
TODO: Check if translation ends with dot or not same as English version

[Table of Contents](#table-of-contents)

## Placeholder genders

When grammatical gender around a placeholder is needed we use majority gender of the placeholder across translation file.</br>
"not applicable" subsection, means a placeholder has gender but is not needed or used in translation.

### Feminine

- [year]
- [nation]
- [civName] (Masculine if it's city state name)
- [civNames]
- [otherCiv]
- [otherCivName]
- [civFilter]
- [currentPlayerCiv]
- [unitType]
- [civ], [civ1], [civ2]
- [civilization]
- [religionFilter]

Feminine but not applicable:

- [feature]
- [allyCivName]
- [enemyCivName]

### Masculine

- [unit]
- [unitName]
- [otherUnitName]
- [oldUnit]
- [newUnit]
- [ourUnit]
- [theirUnit]
- [RangedUnit]
- [attackerName]
- [interceptorName]
- [unitTriggerTarget]
- [mapUnitFilter]
- [attacker]
- [cityName]
- [cityFilter]
- [cityState]
- [cityStateName]
- [resources]
- [greatPerson]
- [specialist]
- [player]
- [numberOfPlayers]
- [numberOfExplicitPlayersText]
- [mods]
- [turns]
- [turnsToExpansion]
- [promotion]

Masculine but not applicable:

- [difficulty]
- [combatantFilter]
- [populationFilter]
- [battleAction]

### Neuter

- [era]
- [eraName]
- [beliefType]
- [saveFileName]
- [currentPlayerCiv]

### Mixed gender

Use neuter in translation:

- [wonder]
- [buildingName]
- [buildingFilter]
- [tileFilter/buildingFilter]
- [construction]
- [constructionName]
- [improvement]
- [improvementName]
- [improvementFilter]
- [resourceName]
- [resourceFilter]
- [stockpiledResource]
- [modName]
- [techName]
- [technologyName]
- [building]
- [resource]

Mixed but use neuter or masculine (depending on context) but not feminine:

- [nukeType]

Mixed but not applicable:

- [terrain]
- [terrainName]
- [terrainFilter]
- [Stats]
- [PolicyOrNationalWonder]

### Guess gender

Try to guess gender depending on context:

- [baseUnitFilter]
- [civWideStat]
- [countable], [countable2], [countable3]
- [policy]
- [code]
- [name]

### Gender not applicable

- [relativeAmount]
- [comment]
- [goldAmount]
- [goldCost]
- [amount], [amount2], [amount3], [amount4]
- [positiveAmount], [positiveAmount2]
- [duration]
- [tileFilter]
- [numberOfTurns]
- [size]
- [serverURL]
- [version]
- [title]
- [naturalWonder]
- [thingToProduce]
- [thingToSelect]
- [count]
- [influenceAmount]
- [amountOfCulture]
- [firstValue]
- [secondValue]
- [questName]

### Unresolved gender

TODO: Which gender are these?</br>
TODO: There are more placeholders in properties not listed here.

- [costOrStrength]
- [param]
- [valueType]
- [ability]

[Table of Contents](#table-of-contents)

## City names

TODO: Orthography and transliteration of city and person names is based on [Resources](#resources) and needs further checks.

City names might have Croatian translation, if not the following rules apply:

### Cities written in English

English city names retain their English writing

- England
- America
- Celts

### Cities written in Latin letter

City names are written the same as in origin language.</br>
For cities of native Americans the language and letter of their conquerors is used.

- France
- Rome
- Germany
- The Ottomans
- Spain
- Denmark
- The Netherlands
- Sweden
- Austria
- Aztecs
- Iroquois
- Inca
- The Maya

### Cities written in Cyrillic letter

Cities are written the same as in origin language, Cyrillic letter is simply converted to Latin letter,
taking care about pronunciation.

- Russia
- Mongolia

### Cities written in other letters

Cities written in letter other than Latin or Cyrillic follow transliteration rules.

- Babylon
- Greece
- China
- Egypt
- Arabia
- Japan
- India
- Korea
- Persia
- Siam
- Carthage
- Songhai
- Ethiopia

### Unknown letter

TODO: Which letter was historically used by these? classify them and verify transliteration of cities.

- Polynesia
- The Huns
- Byzantine empire

[Table of Contents](#table-of-contents)

## Resources

The following resources were helpful for translation of cities and person names:

### Hints

- Wikipedia
- Google maps in local language first (origin country of a city), google maps in Croatian language if local language
  letter is not Latin
- Multiple search engines, meta search engines
- The Bible (e.g. Babylonian and Egyptian cities)
- Country local lexicons, preferably state official lexicons
- Deep web
- Sample articles in Croatian or English language using a word or term which is to be translated

### Links

- [Strana osobna i zemljopisna imena](https://jezicni-savjeti.com.hr/strana-osobna-i-zemljopisna-imena/)
- [Pisanje stranih imena](https://www.lektire.hr/pisanje-stranih-imena/)
- [Pisanje stranih imena](https://sjedi5.com/pisanje-stranih-imena/)
- [Pisanje-i-sklanjanje-stranih-rijeci-i-imena](https://www.pomsk.hr/wp-content/uploads/sites/4/2021/05/Pisanje-i-sklanjanje-stranih-rijeci-i-imena.pdf)
- [Hrvatska enciklopedija](https://enciklopedija.hr/)
- [Hrvatski opći leksikon](https://www.lzmk.hr/izdanja/leksikoni/hrvatski-opci-leksikon)
- [Pojmovnik gradova i lokaliteta stare povijesti](https://www.starapovijest.eu/pojmovnik-gradova-lokaliteta-stare-povijesti/)
- [Popis povijesnih iranskih glavnih gradova](https://hr.wikipedia.org/wiki/Dodatak:Popis_povijesnih_iranskih_glavnih_gradova)
- [Geek pravopis](https://geek.hr/pravopis/)
- [Encyclopedia Iranica](https://iranicaonline.org/)

- TODO: Reference of comprehensive transliteration rules

[Table of Contents](#table-of-contents)

## Gotcha's

- Some city names have modern names, we should retain historical names and not use modern ones.

- Borrowed translation should be get rid of non Croatian letters and combinations of letters like:
  W, Y, CH, SH, replacing them with: V, J, Č, Š etc. but only if that's orthographically correct and
  if transliterations rules allow.

- Note that other slavic countries like Serbia, Macedonia, Slovakia etc. use different transliteration
  rules so they're not appropriate for translation but exceptions exist that can help. (e.g by using wikipedia)

- TODO: Where possible avoid "da" (dakavica) and "bude/budu" etc.
  Note that some cases are orthographically correct.

- Avoid anglicisms, germanisms and other borrowed words unless there is no actual Croatian equivalent

- Avoid archaisms

[Table of Contents](#table-of-contents)
